//**********************************************************************//
//**                                                                  **//
//**              (C)Copyright 1985-2015, Jetway Co.,Ltd              **//
//**                                                                  **//
//**                       All Rights Reserved.                       **//
//**********************************************************************//
//**********************************************************************
// Name:  common.h
//
// Description: Head file of Common routine  for IO access.
//
//**********************************************************************

#ifndef	COMMON_H
#define COMMON_H
//;Data type define
typedef	unsigned char BYTE;			//BYTE type definition = unsigned char (1 byte)
typedef unsigned short WORD;		//WORD type definition = unsigned short (2 bytes)
typedef unsigned int DWORD;			//DWORD type definition = unsigned

//;Parament define
#define ERROR_OK	0			//Error status : OK
#define ERROR_BAD	1			//Error status : Bad parameters
#define ERROR_BAD_ONBOARD	2			//Error status : Bad parameters ONBOARD
#define ERROR_BAD_ETB4G	  3			//Error status : Bad parameters ETB4G
#define	TRUE	1					//TRUE definition
#define FALSE	0					//FALSE definition
#define LOW		0					//
#define HIGH	1					//

//;IO Port define
#define SIO_CONFIG_INDEX	0x4E
#define SIO_CONFIG_DATA 	0x4F
#define SIO_CONFIG_MODE_ENTER_VALUE 0x87
#define SIO_CONFIG_MODE_EXIT_VALUE  0xaa

BYTE inportb(WORD addr);				//Read BYTE data from IO Port addr
void outportb(WORD addr, BYTE data);	//Write BYTE data to IO Port addr
void outportl(WORD addr, DWORD data);	//Write DWORD data to IO Port addr
WORD inportw(WORD addr);				//Read WORD data from IO Port addr

#endif	//COMMON_H